# ============================================================
# Communication entre Arduino et Raspberry Pi via le bus I2C
# ============================================================
# Programme Master qui envoie des instructions vers la Arduino en simulant des registres
# sur la Arduino. S'utilise avec le programme Arduino test-float-arduino.ino
#
# Ce programme doit permettre de recevoir sur la Raspi une valeur float de la part de la Arduino.

import time
import struct
from Adafruit_I2C import Adafruit_I2C

i2c = Adafruit_I2C( 0x04 )

# --- Demander une valeur décimale ---
# Transfert d'un type double

# Demander l'opération de réception d'un float, placer 0x02 dans le
# registre d'exécution 0
i2c.write8( 0x00, 0x02 )
time.sleep( 0.100 )
i2c.debug = True

# Lire 4 octets pour recevoir le float
# Doit recevoir les valeurs [164, 112, 181, 64]
i2c.debug = True
lstData = i2c.readList( 0x00, 4 )

# transformer en string pour unpack
sData = ''
for aByte in lstData:
	sData = sData + chr(aByte)  # chr() retourne un string à partir d'un caractère

f_data, = struct.unpack('<f', sData)
print f_data # Affiche la valeur en float