# Fonctionne avec la librairie python Adafruit_I2C.py
# Programme fonctionnant avec test-hello-arduino.ino

import time
from Adafruit_I2C import Adafruit_I2C
i2c = Adafruit_I2C( 0x04 )

# Ecriture de deux bytes, le registre (ici à 0) et la valeur hexa 0x40
i2c.write8( 0, 0x40 )

# Donner un délai au périphérique I2C pour qu'il soit prêt à recevoir
# une nouvelle communication. Sinon on reçoit l'erreur
# Error accessing 0x04: Check your I2C address
time.sleep( 0.100 )

# Ecriture du message à envoyer sur l'Arduino
# D'abord le registre 0x35
# Les caractères sont convertis en bytes à l'aide de la fonction ord
i2c.writeList ( 0x35, [ord('s'),ord('a'),ord('l'),ord('u'),ord('t')] )

time.sleep( 0.100 )

# Stress test
# On envoie en boucle des messages à l'Arduino (avec le numéro du message)
for i in range(150)
	i2c.writeList( 0x35, [ord('C'),ord('a'),ord(' '),ord('v'), ord('a'),ord('?'), i])
	time.sleep( 0.100 )