// =================================================================
// Communication entre Arduino et Raspberry Pi via le bus I2C
// =================================================================
// Programme Esclave qui reçoit les données envoyées par la Raspberry Pi
// S'utilise avec le programme test-hello-raspi.py

#include <Wire.h>

void setup() {
  // put your setup code here, to run once:
  Wire.begin(4);                // Joindre le bus I2C avec l'adresse #4
  Wire.onReceive(receiveEvent); // Enregistrer l'évènement (lorsqu'une demande arrive)
  Serial.begin(9600);           // Démarrer une communication en série
}

void loop() {
  // put your main code here, to run repeatedly:
  delay(100);
}

// Fonction exécutée lorsque des données sont envoyées par la Raspi
// Cette fonction est enregistrée comme un évènement (cf la fonction setup())
void receiveEvent(int howMany)
{
  Serial.println("---- RECEPTION ----");
  Serial.print("Number of Bytes: ");
  Serial.print( howMany );
  Serial.println("Raspi dit: ");
  while(1 < Wire.available())   // Lire tous les octets sauf le dernier
  {
    char c = Wire.read();       // Lecture de l'octet comme un caractère
    Serial.print(c);            // Affiche le caractère sur le moniteur série
  }
  int n = Wire.read();          // Lecture de l'octet comme un entier
  Serial.println(n);            // Afficher le nombre
}

